<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class CategorydetailstblAdd extends Categorydetailstbl
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'categorydetailstbl';

    // Page object name
    public $PageObjName = "CategorydetailstblAdd";

    // Rendering View
    public $RenderingView = false;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return ($this->TableVar == $CurrentForm->getValue("t"));
            }
            if (Get("t") !== null) {
                return ($this->TableVar == Get("t"));
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (categorydetailstbl)
        if (!isset($GLOBALS["categorydetailstbl"]) || get_class($GLOBALS["categorydetailstbl"]) == PROJECT_NAMESPACE . "categorydetailstbl") {
            $GLOBALS["categorydetailstbl"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'categorydetailstbl');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $doc = new $class(Container("categorydetailstbl"));
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $row = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page
                    $row["caption"] = $this->getModalCaption($pageName);
                    if ($pageName == "categorydetailstblview") {
                        $row["view"] = "1";
                    }
                } else { // List page should not be shown as modal => error
                    $row["error"] = $this->getFailureMessage();
                    $this->clearFailureMessage();
                }
                WriteJson($row);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['Categorydetailsid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->Categorydetailsid->Visible = false;
        }
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }
    public $FormClassName = "ew-horizontal ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $OldRecordset;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
            $SkipHeaderFooter;

        // Is modal
        $this->IsModal = Param("modal") == "1";

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->Categorydetailsid->Visible = false;
        $this->Category_id->setVisibility();
        $this->Category_Abrivation->setVisibility();
        $this->Category_Details->setVisibility();
        $this->Depreciation_Rate->setVisibility();
        $this->Expert_Valuation_Multiplier->setVisibility();
        $this->Created_on->setVisibility();
        $this->Updated_on->Visible = false;
        $this->hideFieldsForAddEdit();

        // Do not use lookup cache
        $this->setUseLookupCache(false);

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->Category_id);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $this->FormClassName = "ew-form ew-add-form ew-horizontal";
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action") !== null) {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("Categorydetailsid") ?? Route("Categorydetailsid")) !== null) {
                $this->Categorydetailsid->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record / default values
        $loaded = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Set up detail parameters
        $this->setupDetailParms();

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$loaded) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("categorydetailstbllist"); // No matching record, return to list
                    return;
                }

                // Set up detail parameters
                $this->setupDetailParms();
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($this->OldRecordset)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    if ($this->getCurrentDetailTable() != "") { // Master/detail add
                        $returnUrl = $this->getDetailUrl();
                    } else {
                        $returnUrl = $this->getReturnUrl();
                    }
                    if (GetPageName($returnUrl) == "categorydetailstbllist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "categorydetailstblview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }
                    if (IsApi()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values

                    // Set up detail parameters
                    $this->setupDetailParms();
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = ROWTYPE_ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Visible", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->Categorydetailsid->CurrentValue = null;
        $this->Categorydetailsid->OldValue = $this->Categorydetailsid->CurrentValue;
        $this->Category_id->CurrentValue = null;
        $this->Category_id->OldValue = $this->Category_id->CurrentValue;
        $this->Category_Abrivation->CurrentValue = null;
        $this->Category_Abrivation->OldValue = $this->Category_Abrivation->CurrentValue;
        $this->Category_Details->CurrentValue = null;
        $this->Category_Details->OldValue = $this->Category_Details->CurrentValue;
        $this->Depreciation_Rate->CurrentValue = 10.00;
        $this->Expert_Valuation_Multiplier->CurrentValue = 100.00;
        $this->Created_on->CurrentValue = null;
        $this->Created_on->OldValue = $this->Created_on->CurrentValue;
        $this->Updated_on->CurrentValue = null;
        $this->Updated_on->OldValue = $this->Updated_on->CurrentValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;

        // Check field name 'Category_id' first before field var 'x_Category_id'
        $val = $CurrentForm->hasValue("Category_id") ? $CurrentForm->getValue("Category_id") : $CurrentForm->getValue("x_Category_id");
        if (!$this->Category_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Category_id->Visible = false; // Disable update for API request
            } else {
                $this->Category_id->setFormValue($val);
            }
        }

        // Check field name 'Category_Abrivation' first before field var 'x_Category_Abrivation'
        $val = $CurrentForm->hasValue("Category_Abrivation") ? $CurrentForm->getValue("Category_Abrivation") : $CurrentForm->getValue("x_Category_Abrivation");
        if (!$this->Category_Abrivation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Category_Abrivation->Visible = false; // Disable update for API request
            } else {
                $this->Category_Abrivation->setFormValue($val);
            }
        }

        // Check field name 'Category_Details' first before field var 'x_Category_Details'
        $val = $CurrentForm->hasValue("Category_Details") ? $CurrentForm->getValue("Category_Details") : $CurrentForm->getValue("x_Category_Details");
        if (!$this->Category_Details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Category_Details->Visible = false; // Disable update for API request
            } else {
                $this->Category_Details->setFormValue($val);
            }
        }

        // Check field name 'Depreciation_Rate' first before field var 'x_Depreciation_Rate'
        $val = $CurrentForm->hasValue("Depreciation_Rate") ? $CurrentForm->getValue("Depreciation_Rate") : $CurrentForm->getValue("x_Depreciation_Rate");
        if (!$this->Depreciation_Rate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Depreciation_Rate->Visible = false; // Disable update for API request
            } else {
                $this->Depreciation_Rate->setFormValue($val);
            }
        }

        // Check field name 'Expert_Valuation_Multiplier' first before field var 'x_Expert_Valuation_Multiplier'
        $val = $CurrentForm->hasValue("Expert_Valuation_Multiplier") ? $CurrentForm->getValue("Expert_Valuation_Multiplier") : $CurrentForm->getValue("x_Expert_Valuation_Multiplier");
        if (!$this->Expert_Valuation_Multiplier->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Expert_Valuation_Multiplier->Visible = false; // Disable update for API request
            } else {
                $this->Expert_Valuation_Multiplier->setFormValue($val);
            }
        }

        // Check field name 'Created_on' first before field var 'x_Created_on'
        $val = $CurrentForm->hasValue("Created_on") ? $CurrentForm->getValue("Created_on") : $CurrentForm->getValue("x_Created_on");
        if (!$this->Created_on->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Created_on->Visible = false; // Disable update for API request
            } else {
                $this->Created_on->setFormValue($val);
            }
            $this->Created_on->CurrentValue = UnFormatDateTime($this->Created_on->CurrentValue, 0);
        }

        // Check field name 'Categorydetailsid' first before field var 'x_Categorydetailsid'
        $val = $CurrentForm->hasValue("Categorydetailsid") ? $CurrentForm->getValue("Categorydetailsid") : $CurrentForm->getValue("x_Categorydetailsid");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->Category_id->CurrentValue = $this->Category_id->FormValue;
        $this->Category_Abrivation->CurrentValue = $this->Category_Abrivation->FormValue;
        $this->Category_Details->CurrentValue = $this->Category_Details->FormValue;
        $this->Depreciation_Rate->CurrentValue = $this->Depreciation_Rate->FormValue;
        $this->Expert_Valuation_Multiplier->CurrentValue = $this->Expert_Valuation_Multiplier->FormValue;
        $this->Created_on->CurrentValue = $this->Created_on->FormValue;
        $this->Created_on->CurrentValue = UnFormatDateTime($this->Created_on->CurrentValue, 0);
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssoc($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }

        // Call Row Selected event
        $this->rowSelected($row);
        if (!$rs) {
            return;
        }
        $this->Categorydetailsid->setDbValue($row['Categorydetailsid']);
        $this->Category_id->setDbValue($row['Category_id']);
        $this->Category_Abrivation->setDbValue($row['Category_Abrivation']);
        $this->Category_Details->setDbValue($row['Category_Details']);
        $this->Depreciation_Rate->setDbValue($row['Depreciation_Rate']);
        $this->Expert_Valuation_Multiplier->setDbValue($row['Expert_Valuation_Multiplier']);
        $this->Created_on->setDbValue($row['Created_on']);
        $this->Updated_on->setDbValue($row['Updated_on']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $this->loadDefaultValues();
        $row = [];
        $row['Categorydetailsid'] = $this->Categorydetailsid->CurrentValue;
        $row['Category_id'] = $this->Category_id->CurrentValue;
        $row['Category_Abrivation'] = $this->Category_Abrivation->CurrentValue;
        $row['Category_Details'] = $this->Category_Details->CurrentValue;
        $row['Depreciation_Rate'] = $this->Depreciation_Rate->CurrentValue;
        $row['Expert_Valuation_Multiplier'] = $this->Expert_Valuation_Multiplier->CurrentValue;
        $row['Created_on'] = $this->Created_on->CurrentValue;
        $row['Updated_on'] = $this->Updated_on->CurrentValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        $this->OldRecordset = null;
        $validKey = $this->OldKey != "";
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Convert decimal values if posted back
        if ($this->Depreciation_Rate->FormValue == $this->Depreciation_Rate->CurrentValue && is_numeric(ConvertToFloatString($this->Depreciation_Rate->CurrentValue))) {
            $this->Depreciation_Rate->CurrentValue = ConvertToFloatString($this->Depreciation_Rate->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->Expert_Valuation_Multiplier->FormValue == $this->Expert_Valuation_Multiplier->CurrentValue && is_numeric(ConvertToFloatString($this->Expert_Valuation_Multiplier->CurrentValue))) {
            $this->Expert_Valuation_Multiplier->CurrentValue = ConvertToFloatString($this->Expert_Valuation_Multiplier->CurrentValue);
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // Categorydetailsid

        // Category_id

        // Category_Abrivation

        // Category_Details

        // Depreciation_Rate

        // Expert_Valuation_Multiplier

        // Created_on

        // Updated_on
        if ($this->RowType == ROWTYPE_VIEW) {
            // Categorydetailsid
            $this->Categorydetailsid->ViewValue = $this->Categorydetailsid->CurrentValue;
            $this->Categorydetailsid->ViewCustomAttributes = "";

            // Category_id
            $curVal = trim(strval($this->Category_id->CurrentValue));
            if ($curVal != "") {
                $this->Category_id->ViewValue = $this->Category_id->lookupCacheOption($curVal);
                if ($this->Category_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Categoryid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Category_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Category_id->Lookup->renderViewRow($rswrk[0]);
                        $this->Category_id->ViewValue = $this->Category_id->displayValue($arwrk);
                    } else {
                        $this->Category_id->ViewValue = $this->Category_id->CurrentValue;
                    }
                }
            } else {
                $this->Category_id->ViewValue = null;
            }
            $this->Category_id->ViewCustomAttributes = "";

            // Category_Abrivation
            $this->Category_Abrivation->ViewValue = $this->Category_Abrivation->CurrentValue;
            $this->Category_Abrivation->ViewCustomAttributes = "";

            // Category_Details
            $this->Category_Details->ViewValue = $this->Category_Details->CurrentValue;
            $this->Category_Details->ViewCustomAttributes = "";

            // Depreciation_Rate
            $this->Depreciation_Rate->ViewValue = $this->Depreciation_Rate->CurrentValue;
            $this->Depreciation_Rate->ViewValue = FormatNumber($this->Depreciation_Rate->ViewValue, 2, -2, -2, -2);
            $this->Depreciation_Rate->ViewCustomAttributes = "";

            // Expert_Valuation_Multiplier
            $this->Expert_Valuation_Multiplier->ViewValue = $this->Expert_Valuation_Multiplier->CurrentValue;
            $this->Expert_Valuation_Multiplier->ViewValue = FormatNumber($this->Expert_Valuation_Multiplier->ViewValue, 2, -2, -2, -2);
            $this->Expert_Valuation_Multiplier->ViewCustomAttributes = "";

            // Created_on
            $this->Created_on->ViewValue = $this->Created_on->CurrentValue;
            $this->Created_on->ViewValue = FormatDateTime($this->Created_on->ViewValue, 0);
            $this->Created_on->ViewCustomAttributes = "";

            // Category_id
            $this->Category_id->LinkCustomAttributes = "";
            $this->Category_id->HrefValue = "";
            $this->Category_id->TooltipValue = "";

            // Category_Abrivation
            $this->Category_Abrivation->LinkCustomAttributes = "";
            $this->Category_Abrivation->HrefValue = "";
            $this->Category_Abrivation->TooltipValue = "";

            // Category_Details
            $this->Category_Details->LinkCustomAttributes = "";
            $this->Category_Details->HrefValue = "";
            $this->Category_Details->TooltipValue = "";

            // Depreciation_Rate
            $this->Depreciation_Rate->LinkCustomAttributes = "";
            $this->Depreciation_Rate->HrefValue = "";
            $this->Depreciation_Rate->TooltipValue = "";

            // Expert_Valuation_Multiplier
            $this->Expert_Valuation_Multiplier->LinkCustomAttributes = "";
            $this->Expert_Valuation_Multiplier->HrefValue = "";
            $this->Expert_Valuation_Multiplier->TooltipValue = "";

            // Created_on
            $this->Created_on->LinkCustomAttributes = "";
            $this->Created_on->HrefValue = "";
            $this->Created_on->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // Category_id
            $this->Category_id->EditAttrs["class"] = "form-control";
            $this->Category_id->EditCustomAttributes = "";
            $curVal = trim(strval($this->Category_id->CurrentValue));
            if ($curVal != "") {
                $this->Category_id->ViewValue = $this->Category_id->lookupCacheOption($curVal);
            } else {
                $this->Category_id->ViewValue = $this->Category_id->Lookup !== null && is_array($this->Category_id->Lookup->Options) ? $curVal : null;
            }
            if ($this->Category_id->ViewValue !== null) { // Load from cache
                $this->Category_id->EditValue = array_values($this->Category_id->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Categoryid`" . SearchString("=", $this->Category_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Category_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Category_id->EditValue = $arwrk;
            }
            $this->Category_id->PlaceHolder = RemoveHtml($this->Category_id->caption());

            // Category_Abrivation
            $this->Category_Abrivation->EditAttrs["class"] = "form-control";
            $this->Category_Abrivation->EditCustomAttributes = "";
            if (!$this->Category_Abrivation->Raw) {
                $this->Category_Abrivation->CurrentValue = HtmlDecode($this->Category_Abrivation->CurrentValue);
            }
            $this->Category_Abrivation->EditValue = HtmlEncode($this->Category_Abrivation->CurrentValue);
            $this->Category_Abrivation->PlaceHolder = RemoveHtml($this->Category_Abrivation->caption());

            // Category_Details
            $this->Category_Details->EditAttrs["class"] = "form-control";
            $this->Category_Details->EditCustomAttributes = "";
            if (!$this->Category_Details->Raw) {
                $this->Category_Details->CurrentValue = HtmlDecode($this->Category_Details->CurrentValue);
            }
            $this->Category_Details->EditValue = HtmlEncode($this->Category_Details->CurrentValue);
            $this->Category_Details->PlaceHolder = RemoveHtml($this->Category_Details->caption());

            // Depreciation_Rate
            $this->Depreciation_Rate->EditAttrs["class"] = "form-control";
            $this->Depreciation_Rate->EditCustomAttributes = "";
            $this->Depreciation_Rate->EditValue = HtmlEncode($this->Depreciation_Rate->CurrentValue);
            $this->Depreciation_Rate->PlaceHolder = RemoveHtml($this->Depreciation_Rate->caption());
            if (strval($this->Depreciation_Rate->EditValue) != "" && is_numeric($this->Depreciation_Rate->EditValue)) {
                $this->Depreciation_Rate->EditValue = FormatNumber($this->Depreciation_Rate->EditValue, -2, -2, -2, -2);
            }

            // Expert_Valuation_Multiplier
            $this->Expert_Valuation_Multiplier->EditAttrs["class"] = "form-control";
            $this->Expert_Valuation_Multiplier->EditCustomAttributes = "";
            $this->Expert_Valuation_Multiplier->EditValue = HtmlEncode($this->Expert_Valuation_Multiplier->CurrentValue);
            $this->Expert_Valuation_Multiplier->PlaceHolder = RemoveHtml($this->Expert_Valuation_Multiplier->caption());
            if (strval($this->Expert_Valuation_Multiplier->EditValue) != "" && is_numeric($this->Expert_Valuation_Multiplier->EditValue)) {
                $this->Expert_Valuation_Multiplier->EditValue = FormatNumber($this->Expert_Valuation_Multiplier->EditValue, -2, -2, -2, -2);
            }

            // Created_on

            // Add refer script

            // Category_id
            $this->Category_id->LinkCustomAttributes = "";
            $this->Category_id->HrefValue = "";

            // Category_Abrivation
            $this->Category_Abrivation->LinkCustomAttributes = "";
            $this->Category_Abrivation->HrefValue = "";

            // Category_Details
            $this->Category_Details->LinkCustomAttributes = "";
            $this->Category_Details->HrefValue = "";

            // Depreciation_Rate
            $this->Depreciation_Rate->LinkCustomAttributes = "";
            $this->Depreciation_Rate->HrefValue = "";

            // Expert_Valuation_Multiplier
            $this->Expert_Valuation_Multiplier->LinkCustomAttributes = "";
            $this->Expert_Valuation_Multiplier->HrefValue = "";

            // Created_on
            $this->Created_on->LinkCustomAttributes = "";
            $this->Created_on->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if ($this->Category_id->Required) {
            if (!$this->Category_id->IsDetailKey && EmptyValue($this->Category_id->FormValue)) {
                $this->Category_id->addErrorMessage(str_replace("%s", $this->Category_id->caption(), $this->Category_id->RequiredErrorMessage));
            }
        }
        if ($this->Category_Abrivation->Required) {
            if (!$this->Category_Abrivation->IsDetailKey && EmptyValue($this->Category_Abrivation->FormValue)) {
                $this->Category_Abrivation->addErrorMessage(str_replace("%s", $this->Category_Abrivation->caption(), $this->Category_Abrivation->RequiredErrorMessage));
            }
        }
        if ($this->Category_Details->Required) {
            if (!$this->Category_Details->IsDetailKey && EmptyValue($this->Category_Details->FormValue)) {
                $this->Category_Details->addErrorMessage(str_replace("%s", $this->Category_Details->caption(), $this->Category_Details->RequiredErrorMessage));
            }
        }
        if ($this->Depreciation_Rate->Required) {
            if (!$this->Depreciation_Rate->IsDetailKey && EmptyValue($this->Depreciation_Rate->FormValue)) {
                $this->Depreciation_Rate->addErrorMessage(str_replace("%s", $this->Depreciation_Rate->caption(), $this->Depreciation_Rate->RequiredErrorMessage));
            }
        }
        if (!CheckRange($this->Depreciation_Rate->FormValue, 0.00, 100.00)) {
            $this->Depreciation_Rate->addErrorMessage($this->Depreciation_Rate->getErrorMessage(false));
        }
        if ($this->Expert_Valuation_Multiplier->Required) {
            if (!$this->Expert_Valuation_Multiplier->IsDetailKey && EmptyValue($this->Expert_Valuation_Multiplier->FormValue)) {
                $this->Expert_Valuation_Multiplier->addErrorMessage(str_replace("%s", $this->Expert_Valuation_Multiplier->caption(), $this->Expert_Valuation_Multiplier->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->Expert_Valuation_Multiplier->FormValue)) {
            $this->Expert_Valuation_Multiplier->addErrorMessage($this->Expert_Valuation_Multiplier->getErrorMessage(false));
        }
        if ($this->Created_on->Required) {
            if (!$this->Created_on->IsDetailKey && EmptyValue($this->Created_on->FormValue)) {
                $this->Created_on->addErrorMessage(str_replace("%s", $this->Created_on->caption(), $this->Created_on->RequiredErrorMessage));
            }
        }

        // Validate detail grid
        $detailTblVar = explode(",", $this->getCurrentDetailTable());
        $detailPage = Container("AssetconditionvaluationtblGrid");
        if (in_array("assetconditionvaluationtbl", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->validateGridForm();
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;
        $conn = $this->getConnection();

        // Begin transaction
        if ($this->getCurrentDetailTable() != "") {
            $conn->beginTransaction();
        }

        // Load db values from rsold
        $this->loadDbValues($rsold);
        if ($rsold) {
        }
        $rsnew = [];

        // Category_id
        $this->Category_id->setDbValueDef($rsnew, $this->Category_id->CurrentValue, 0, false);

        // Category_Abrivation
        $this->Category_Abrivation->setDbValueDef($rsnew, $this->Category_Abrivation->CurrentValue, null, false);

        // Category_Details
        $this->Category_Details->setDbValueDef($rsnew, $this->Category_Details->CurrentValue, "", false);

        // Depreciation_Rate
        $this->Depreciation_Rate->setDbValueDef($rsnew, $this->Depreciation_Rate->CurrentValue, 0, strval($this->Depreciation_Rate->CurrentValue) == "");

        // Expert_Valuation_Multiplier
        $this->Expert_Valuation_Multiplier->setDbValueDef($rsnew, $this->Expert_Valuation_Multiplier->CurrentValue, 0, strval($this->Expert_Valuation_Multiplier->CurrentValue) == "");

        // Created_on
        $this->Created_on->CurrentValue = CurrentDate();
        $this->Created_on->setDbValueDef($rsnew, $this->Created_on->CurrentValue, null);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        $addRow = false;
        if ($insertRow) {
            try {
                $addRow = $this->insert($rsnew);
            } catch (\Exception $e) {
                $this->setFailureMessage($e->getMessage());
            }
            if ($addRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }

        // Add detail records
        if ($addRow) {
            $detailTblVar = explode(",", $this->getCurrentDetailTable());
            $detailPage = Container("AssetconditionvaluationtblGrid");
            if (in_array("assetconditionvaluationtbl", $detailTblVar) && $detailPage->DetailAdd) {
                $detailPage->Categorydetailsid->setSessionValue($this->Categorydetailsid->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "assetconditionvaluationtbl"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->Categorydetailsid->setSessionValue(""); // Clear master key if insert failed
                }
            }
        }

        // Commit/Rollback transaction
        if ($this->getCurrentDetailTable() != "") {
            if ($addRow) {
                $conn->commit(); // Commit transaction
            } else {
                $conn->rollback(); // Rollback transaction
            }
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Clean upload path if any
        if ($addRow) {
        }

        // Write JSON for API request
        if (IsApi() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $addRow;
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("assetconditionvaluationtbl", $detailTblVar)) {
                $detailPageObj = Container("AssetconditionvaluationtblGrid");
                if ($detailPageObj->DetailAdd) {
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->Categorydetailsid->IsDetailKey = true;
                    $detailPageObj->Categorydetailsid->CurrentValue = $this->Categorydetailsid->CurrentValue;
                    $detailPageObj->Categorydetailsid->setSessionValue($detailPageObj->Categorydetailsid->CurrentValue);
                    $detailPageObj->Condition_id->setSessionValue(""); // Clear session key
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("dashboard2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("categorydetailstbllist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_Category_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in CustomError
        return true;
    }
}
